{ A form to view and edit data. Currently there are two types of data that can
  be shown in this form, state variables and process variables.
  The state variables form allows the user to view and edit the state variables.
  The process variable form is used for viewing only. The user can not edit the
  process variables directly. To change a process value it is necessary to
  modify the parameters in the parameter form. The process values shown in this
  form are automatically updated when the process values in the parameter form
  are updated.
 }
unit data;
     
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids,stypes, StdCtrls, ExtCtrls, AdvGrid, BaseGrid;

type
  TDataForm = class(TForm)
    PnlTop: TPanel;
    BtnOK: TButton;
    BtnCancel: TButton;
    DlgPrint: TPrintDialog;
    BtPrint: TButton;
    ScrollBox1: TScrollBox;
    AdvStringGrid1: TAdvStringGrid;
    procedure BtnOKClick(Sender: TObject);
    procedure BtPrintClick(Sender: TObject);
    procedure ShowStates;
    procedure SaveStates;
    procedure ShowProcess;
    procedure UpdateProcess;
    procedure ClearGrid;
    procedure BtnCancelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
//    procedure FormDestroy(Sender: TObject);
    procedure AdvStringGrid1SelectCell(Sender: TObject; Col, Row: Integer;
      var CanSelect: Boolean);
    procedure AdvStringGrid1GetCellColor(Sender: TObject; ARow,
      ACol: Longint; AState: TGridDrawState; ABrush: TBrush; AFont: TFont);
    procedure AdvStringGrid1DrawCell(Sender: TObject; Col, Row: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure AdvStringGrid1CheckBoxClick(Sender: TObject; aCol,
      aRow: Integer; state: Boolean);
    procedure AdvStringGrid1GetAlignment(Sender: TObject; ARow,
      ACol: Integer; var HAlign: TAlignment; var VAlign: TVAlignment);
  private
    { Private declarations }
    ftempState:Statearray;
  public
    { Public declarations }
  end;

var
  DataForm : TDataForm;
  DataShowing : TDataType;

implementation

uses fileio, frontend, params;

{$R *.DFM}

// Set up the form
procedure TDataForm.FormCreate(Sender: TObject);
var
 j:integer;
begin
  for j := 1 to ModelDef.numstate do
   begin
    AdvStringGrid1.AddCheckBox(0,j,false,false);
    AdvStringGrid1.AddCheckBox(1,j,false,false);
   end;
end;

// Set up the form to show state variables then show the data
procedure tDataForm.ShowStates;
var
 i:integer;
begin
 ftempState := stat;
 Caption := 'State Variables';    // Form Caption
 DataShowing := dtState;
 AdvStringGrid1.UnhideColumn(0);
 AdvStringGrid1.UnhideColumn(1);
 AdvStringGrid1.rowcount:=ModelDef.numstate+1;
 AdvStringGrid1.FixedRows := 1;
 AdvStringGrid1.Col := 3;
 AdvStringGrid1.Row := 1;
 AdvStringGrid1.Options := [goFixedVertLine,goFixedHorzLine,goVertLine,goHorzLine,
           goColSizing,goThumbTracking,goEditing];
 AdvStringGrid1.cells[0,0]:='HoldConstant?';
 AdvStringGrid1.cells[1,0]:='Reset?';
 AdvStringGrid1.cells[2,0]:='State Symbol';
 AdvStringGrid1.cells[3,0]:='State Variable Name';
 AdvStringGrid1.cells[4,0]:='State Variable Value';
 AdvStringGrid1.cells[5,0]:='State Variable Units';
 for i:= 1 to ModelDef.numstate do  // Write state variables, names, values and
   begin                            // units to grid
     AdvStringGrid1.cells[2,i] := stat[i].symbol;
     AdvStringGrid1.cells[3,i] := stat[i].name;
     AdvStringGrid1.Cells[5,i] := stat[i].units;
     AdvStringGrid1.cells[4,i] := floattostr(stat[i].value);
     if stat[i].holdconstant then
      AdvStringGrid1.SetCheckBoxState(0,i,true)
     else
      AdvStringGrid1.SetCheckBoxState(0,i,false);
     if stat[i].reset then
      AdvStringGrid1.SetCheckBoxState(1,i,true)
     else
      AdvStringGrid1.SetCheckBoxState(1,i,false);
   end;
 AdvStringGrid1.AutoSizeCells(true,3,0);
 AdvStringGrid1.RowHeights[0] := AdvStringGrid1.RowHeights[1];
 BtnOK.Visible := True;
 BtnOK.Enabled := True;
 BtnCancel.Caption := '&Cancel';
 DataForm.ActiveControl := AdvStringGrid1;
 ShowModal;   // Show the form
end;

// Set up the form to show process variables then show the data
procedure tDataForm.ShowProcess;
begin
 ftempState := stat; // Necessary so that initial state variable values are saved.
 Caption := 'Process Variables';    // Form Caption
 DataShowing := dtProcess;
 AdvStringGrid1.HideColumn(0);  // StringGrid Properties for process variables
 AdvStringGrid1.HideColumn(1);  // StringGrid Properties for process variables
 AdvStringGrid1.rowcount:=ModelDef.numprocess+1;
 AdvStringGrid1.FixedRows := 1;
 AdvStringGrid1.Options := [goFixedVertLine,goFixedHorzLine,goVertLine,goHorzLine,
           goColSizing,goThumbTracking];
 AdvStringGrid1.cells[2,0]:='Process Symbol';
 AdvStringGrid1.cells[3,0]:='Process Name';
 AdvStringGrid1.cells[4,0]:='Process Value';
 AdvStringGrid1.cells[5,0]:='Process Units';
 UpdateProcess;
 AdvStringGrid1.AutoSizeCells(true,3,0);
 AdvStringGrid1.DefaultRowHeight := AdvStringGrid1.RowHeights[60];
 BtnOK.Visible := False;
 BtnOK.Enabled := False;
 BtnCancel.Caption := '&Close';
 Show;
end;

// Form has been modified, user wants to keep the changes
procedure TDataForm.BtnOKClick(Sender: TObject);
begin
//if DataShowing = dtState{ and AdvStringGrid1Modified }then
// begin
  SaveStates;
  ClearGrid;
  NeedToSavePar := True;   // State variables have been changed, parameter file
                           // needs to be saved
  RunComplete := False;
// end
end;

// Clear the grid when the form closes. When the form is showing process
// variables also close the form manually since it doesn't do it automatically.
procedure TDataForm.BtnCancelClick(Sender: TObject);
begin
 stat := ftempState;
 ClearGrid;
 if DataShowing = dtProcess then Close;
end;

// Update global array of state variables with the changes made to the string grid
procedure tDataForm.SaveStates;
var
 i:integer;
 ConstantState, ResetState:boolean;
begin
 for i:=1 to ModelDef.numstate do
   begin   // Copy value in grid to the global state array
     stat[i].value := strtofloat(AdvStringGrid1.Cells[4,i]);
     AdvStringGrid1.GetCheckBoxState(0,i,ConstantState);
     AdvStringGrid1.GetCheckBoxState(1,i,ResetState);
     if ConstantState then
      stat[i].holdconstant := true
     else
      stat[i].holdconstant := false;
     if ResetState then
      stat[i].reset := true
     else
      stat[i].reset := false;
   end;
end;

{ The procedure updates the process variable values shown in the Dataform.}
procedure tDataForm.UpdateProcess;
var
 i:integer;
begin
 for i:= 1 to ModelDef.numprocess do  // Write process variables, names, values and
   begin                            // units to grid
     AdvStringGrid1.cells[3,i] := proc[i].name;
     AdvStringGrid1.Cells[5,i] := proc[i].units;
     AdvStringGrid1.Cells[2,i] := proc[i].symbol;
     AdvStringGrid1.cells[4,i] := floattostr(proc[i].value);
   end;
end;

// Clear the StringGrid so that new data can be written to it
procedure tDataForm.ClearGrid;
var
 i,j : integer;
begin    // Set grid cells to empty strings
 for i := 0 to AdvStringGrid1.RowCount - 1 do
   for j := 0 to AdvStringGrid1.ColCount - 1 do
    AdvStringGrid1.Cells[j,i] := '';
 AdvStringGrid1.RowCount := 3;   // Reset row count
end;

// Print out the state variables.
{ This procedure is currently not enabled because it will only print the visible
  state variables. Needs to be fixed to print them all. }
procedure TDataForm.BtPrintClick(Sender: TObject);
begin
with DlgPrint do
   if execute then
     Print;
end;

procedure TDataForm.AdvStringGrid1SelectCell(Sender: TObject; Col,
  Row: Integer; var CanSelect: Boolean);
begin
if DataShowing =dtstate then
 if (Col = 4) then
  CanSelect := True
 else
  CanSelect := False
else
 CanSelect := False;
end;

procedure TDataForm.AdvStringGrid1GetCellColor(Sender: TObject; ARow,
  ACol: Longint; AState: TGridDrawState; ABrush: TBrush; AFont: TFont);
begin
 if DataShowing = dtstate then
  begin
    if acol in [0,1,2,3,5] then
     begin
      abrush.color:=clScrollBar;
     end;
  end
 else
  begin
    abrush.color := clScrollBar
  end;
 if (arow=0) then
    begin
     afont.style:=[fsBold];
    end;
end;

procedure TDataForm.AdvStringGrid1DrawCell(Sender: TObject; Col,
  Row: Integer; Rect: TRect; State: TGridDrawState);
var
 CurrentGrid : TAdvStringGrid;
begin
 if Sender is TAdvStringGrid then
  begin
   CurrentGrid := Sender as TAdvStringGrid;
{   CurrentGrid.Canvas.Brush.Color := clScrollBar;
   if CurrentGrid.Owner = DataForm then
   begin
    if DataShowing = dtstate then
     begin                                    This part doesn't work because the
      if Col in [0,1,2,4] then                text in the cell gets overwritten.
       begin
        CurrentGrid.Canvas.FillRect(Rect);
       end;
     end
    else
     begin
      CurrentGrid.Canvas.FillRect(Rect);
     end;
//    if (Row=0) then
//     begin
//      font.style:=[fsBold];
//     end;
   end; }
   CurrentGrid.Canvas.Brush.Color := clBtnShadow;
   CurrentGrid.Canvas.FrameRect(Rect);
  end;
end;

procedure TDataForm.AdvStringGrid1CheckBoxClick(Sender: TObject; aCol,
  aRow: Integer; state: Boolean);
begin
 if aCol = 0 then
   stat[aRow].holdconstant := state
 else
   stat[aRow].reset := state;
end;

procedure TDataForm.AdvStringGrid1GetAlignment(Sender: TObject; ARow,
  ACol: Integer; var HAlign: TAlignment; var VAlign: TVAlignment);
begin
 if acol in [0,1] then HAlign:=taCenter;
end;

end.
